*******************************************
*** This do-file creates tables 2 and 3 ***
*******************************************

clear
clear matrix
set mem 300m

* !!! PLEASE SPECIFY !!! the directory where the file nj_respondents_new.dta is stored:
local njdir=""

* load file
use `njdir'nj_respondents_new.dta, clear

* sample restriction: age 20-65, not working in survey week, did not accept job in survey week or earlier
drop if insample_wrkacc==0
drop if age > 65
drop if age < 20

* generate day of the week dummies (for time use diary)
tab q2, gen(q2_)
drop q2_1

* dummy for post-nov8
gen postnov8 = (stopday>=18210) if stopday!=.

* rescale weekly job search time
replace tw_jobsearch = 60*tw_jobsearch/7

* "curwkwgt_tu" is the time use diary weight (which assigns weekdays and weekends the correct shares).
* We do not use these weights here, but drop observations when the weights are missing.
* The weights are missing for low quality diaries (more than 2 episodes missing in diary, less than 4 different activities in diary)
replace tu_jobsearch=. if curwkwgt_tu==.
replace tp_jobsearch=. if curwkwgt_tu==.




*** Table 2a: diary job search regressions table ***
eststo table2a_1: reg tu_jobsearch udur_wkpd_wrkacc lprevwage_wklytc lbenerate age agesq educsvy_* female r_* ethnic_* q2_* [pw=perswgt] if week==1, cluster(caseid)
estadd ysumm, mean min max
eststo table2a_2: reg tu_jobsearch udur_wkpd_wrkacc lprevwage_wklytc lbenerate age agesq educsvy_* female r_* ethnic_* q2_* [pw=curwkwgt], cluster(caseid)
estadd ysumm, mean min max
eststo table2a_2b: reg tu_jobsearch udur_wkpd_wrkacc lprevwage_wklytc lbenerate age agesq educsvy_* female r_* ethnic_* q2_* coh_* [pw=curwkwgt], cluster(caseid)
estadd ysumm, mean min max
eststo table2a_3: areg tu_jobsearch udur_wkpd_wrkacc q2_* [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table2a_5: areg tu_jobsearch udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8 q2_* [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max


*** Table 2b: weekly job search regressions table ***
eststo table2b_1: reg tw_jobsearch udur_wkpd_wrkacc lprevwage_wklytc lbenerate age agesq educsvy_* female r_* ethnic_*  [pw=perswgt] if week==1, cluster(caseid)
estadd ysumm, mean min max
eststo table2b_2: reg tw_jobsearch udur_wkpd_wrkacc lprevwage_wklytc lbenerate age agesq educsvy_* female r_* ethnic_*   [pw=curwkwgt], cluster(caseid)
estadd ysumm, mean min max
eststo table2b_2b: reg tw_jobsearch udur_wkpd_wrkacc lprevwage_wklytc lbenerate age agesq educsvy_* female r_* ethnic_* coh_*   [pw=curwkwgt], cluster(caseid)
estadd ysumm, mean min max
eststo table2b_3: areg tw_jobsearch udur_wkpd_wrkacc  [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table2b_5: areg tw_jobsearch udur_wkpd_wrkacc tempexhaustcui1 exhaustcui1 postnov8 [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max




*** Table 2add: Evidence against seasonal effects ***
eststo table2add_novdec: areg tu_jobsearch udur_wkpd_wrkacc q2_* [pw=curwkwgt] ///
if fmonth==10|fmonth==1|fmonth==2|fmonth==3|fmonth==4|(fmonth==11&fday<=15)|(fmonth==12&fday<=15), absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table2add_cons: areg tu_jobsearch udur_wkpd_wrkacc q2_* [pw=curwkwgt] ///
if ind_cons==1, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table2add_nocons: areg tu_jobsearch udur_wkpd_wrkacc q2_* [pw=curwkwgt] ///
if ind_cons==0, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table2add_marriedfemale: areg tu_jobsearch udur_wkpd_wrkacc q2_* [pw=curwkwgt] ///
if female==1 & married==1, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table2add_men: areg tu_jobsearch udur_wkpd_wrkacc q2_* [pw=curwkwgt] ///
if female==0, absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

* morning vs afternoon / sleeping vs job search
gen tu_jobsearch_m = 0 if tu_jobsearch!=.
gen tu_jobsearch_a = 0 if tu_jobsearch!=.
gen tu_sleeping_m = 0 if tu_sleeping!=.
gen tu_sleeping_a = 0 if tu_sleeping!=.

forvalues x=1(1)6 {
replace tu_jobsearch_m = tu_jobsearch_m + tu_jobsearch`x'
replace tu_sleeping_m = tu_sleeping_m + tu_sleeping`x'
}
forvalues x=7(1)16 {
replace tu_jobsearch_a = tu_jobsearch_a + tu_jobsearch`x'
replace tu_sleeping_a = tu_sleeping_a + tu_sleeping`x'
}

eststo table2add_jsmorning: areg tu_jobsearch_m udur_wkpd_wrkacc q2_* [pw=curwkwgt] if curwkwgt_tu!=., absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table2add_jsafternoon: areg tu_jobsearch_a udur_wkpd_wrkacc q2_* [pw=curwkwgt] if curwkwgt_tu!=., absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table2add_sleeping: areg tu_sleeping udur_wkpd_wrkacc q2_* [pw=curwkwgt] if curwkwgt_tu!=., absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table2add_sleepingmorning: areg tu_sleeping_m udur_wkpd_wrkacc q2_* [pw=curwkwgt] if curwkwgt_tu!=., absorb(caseid) cluster(caseid)
estadd ysumm, mean min max

eststo table2add_sleepingafternoon: areg tu_sleeping_a udur_wkpd_wrkacc q2_* [pw=curwkwgt] if curwkwgt_tu!=., absorb(caseid) cluster(caseid)
estadd ysumm, mean min max




*** Table 2add2: Evidence against reporting bias ***
gen intweek2 = week
replace intweek2 = 6 if week>=6 & week!=.
tab intweek2, gen(intweekn_)
drop intweekn_1

eststo table2add2_1: areg tw_jobsearch udur_wkpd_wrkacc intweek [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table2add2_2: areg tw_jobsearch udur_wkpd_wrkacc intweek tempexhaustcui1 exhaustcui1 postnov8 [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table2add2_3: areg tw_jobsearch udur_wkpd_wrkacc intweekn_* [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table2add2_4: areg tw_jobsearch udur_wkpd_wrkacc intweekn_* tempexhaustcui1 exhaustcui1 postnov8 [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max


eststo table2add2_5: areg tu_jobsearch udur_wkpd_wrkacc intweek q2_* [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table2add2_6: areg tu_jobsearch udur_wkpd_wrkacc intweek tempexhaustcui1 exhaustcui1 postnov8 q2_* [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table2add2_7: areg tu_jobsearch udur_wkpd_wrkacc intweekn_* q2_* [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
eststo table2add2_8: areg tu_jobsearch udur_wkpd_wrkacc intweekn_* tempexhaustcui1 exhaustcui1 postnov8 q2_* [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max




*** Table 3: job search method regressions ***
eststo table3_tw_jobsearch: areg tw_jobsearch udur_wkpd_wrkacc [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max


forvalues x=1(1)12 {
gen q10a_`x'_rescaled = 60*q10a_`x'/7
eststo table3_q10a_a`x':  areg q10a_`x'_rescaled udur_wkpd_wrkacc [pw=curwkwgt], absorb(caseid) cluster(caseid)
estadd ysumm, mean min max
}







estout table2a_* table2b_* using brookings_table2.txt, ///
cells(b(fmt(3)) se(par star fmt(3))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2) replace

estout table2add_* using brookings_tableseasonal.txt, ///
cells(b(fmt(3)) se(par star fmt(3))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2) replace

estout table2add2_* using brookings_tablereporting.txt, ///
cells(b(fmt(3)) se(par star fmt(3))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2) replace

estout table3_* using brookings_table3.txt, ///
cells(b(fmt(3)) se(par star fmt(3))) starlevels(* 0.1 ** 0.05 *** 0.01) legend margin stats(ymean ymin ymax N r2) replace


eststo clear

stop
